<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rule;

class AssetUploadRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'file_name' => [
                'sometimes',
                'alpha_dash'
            ],
            'file' => [
                'required',
                'file',
            ],
            'visibility' => [
                'required',
                Rule::in(['public', 'private']),
            ],
            'overwrite' => [
                'sometimes',
            ]
        ];
    }

    public function getFileName(): string
    {
        if ($this->filled('file_name')) {
            return $this->input('file_name') . '.' . $this->file('file')->getClientOriginalExtension();
        }
        return $this->file('file')->getClientOriginalName();
    }
}
