<?php

namespace App\Checklist;

use App\Contracts\GoLiveChecklist;
use App\Facades\Settings;

class SiteEmailCheck extends GoLiveChecklist
{
    public function category(): string
    {
        return GoLiveChecklist::CONFIGURATION;
    }

    public function key(): string
    {
        return 'site_email';
    }

    public function handle(): bool
    {
        $has_email = !empty(Settings::get('app-contact-contact_email'));
        if (!$has_email) {
            $this->failure_reason = __('go-live.errors.no-email');
        }
        return $has_email;
    }
}
