<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class EnquiriesSendPartialSubmissions extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'General',
                'name' => 'Process partially submitted enquiries after X minutes of inactivity',
                'config_key' => 'crm-ingest-partial-submissions-minutes',
                'type' => 'number',
                'min_tier' => 'standard',
                'value' => 0,
                'order' => 3,
                'description' => 'Number of minutes of inactivity to start processing enquiry. 0 to not process partial submissions',
            ],
        ];
    }
}
