<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class EnquiryMaxSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'enquiryMax',
                'name' => 'Enabled',
                'config_key' => 'crm-enquiry-max-enabled',
                'type' => 'boolean',
                'value' => false,
                'description' => '<a href="https://www.keyloop.com/sales/enquirymax" target="_blank">enquiryMax</a> lead management integration.'
            ],
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'enquiryMax',
                'name' => 'EnquiryMax Client ID',
                'config_key' => 'crm-enquiry-max-client-id',
                'type' => 'string',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.crm-enquiry-max-enabled,true"
                ]
            ],
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'enquiryMax',
                'name' => 'EnquiryMax Client Secret',
                'config_key' => 'crm-enquiry-max-client-secret',
                'type' => 'secret',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.crm-enquiry-max-enabled,true"
                ]
            ],
        ];
    }
}
