<?php

namespace Tests\Feature\Commands;

use App\Facades\Settings;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Config;

trait SyncVehicleTrait
{
    public function basicSetup()
    {
        parent::setUp();

        Config::set('queue.default', 'sync');
        Settings::shouldReceive('get')->andReturn(null)->byDefault();

        Settings::shouldReceive('get')
            ->with('stock-sync-frequency')
            ->andReturn('every-hour');

        // ensures fullSync returns true
        $this->travelTo(now()->setHour(4));

        Http::preventStrayRequests();
    }
}
