<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Mtc\MercuryDataModels\Dealership;
use Mtc\MercuryDataModels\NewCar;
use Mtc\MercuryDataModels\Traits\HasDealershipAccessScope;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\MercuryDataModels\VehicleOffer;
use Symfony\Component\HttpFoundation\Response;

class ApplyDealershipScopeMiddleware
{
    /**
     * Models that should have dealership access scoping applied.
     */
    protected array $scopedModels = [
        Vehicle::class,
        VehicleOffer::class,
        NewCar::class,
        Dealership::class,
    ];

    /**
     * Handle an incoming request.
     *
     * Adds a global scope to dealership-related models that filters
     * results based on the authenticated user's dealership access.
     */
    public function handle(Request $request, Closure $next): Response
    {
        $user = $request->user();

        if ($user) {
            collect($this->scopedModels)->each(function ($modelClass) use ($user) {
                $modelClass::addGlobalScope(HasDealershipAccessScope::class, function ($builder) use ($user) {
                    $builder->forUser($user);
                });
            });
        }

        return $next($request);
    }
}
