<?php

namespace Database\Seeders\Tenant;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Mtc\MercuryDataModels\Dealership;

class UserDealershipSeeder extends Seeder
{
    /**
     * Assign all tenant users to all dealerships.
     */
    public function run(): void
    {
        $userIds = tenant()->users()->pluck('users.id');

        if ($userIds->isEmpty()) {
            return;
        }

        $dealershipIds = Dealership::pluck('id');

        if ($dealershipIds->isEmpty()) {
            return;
        }

        $userIds->each(function ($userId) use ($dealershipIds) {
            $dealershipIds->each(fn ($dealershipId) =>
                DB::table('user_dealerships')->insert([
                    'user_id' => $userId,
                    'dealership_id' => $dealershipId,
                ]));
        });
    }
}
