<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class VehicleOfferLinkWithNewCarTrimSetting extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'Offers',
                'name' => 'Link offers to new vehicle records',
                'config_key' => 'offers-link-with-new-car',
                'type' => 'boolean',
                'value' => false,
                'description' => 'Allows to select related new vehicle record for better matching',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'Offers',
                'name' => 'Link offers to new vehicle trims',
                'config_key' => 'offers-link-with-trim',
                'type' => 'boolean',
                'value' => false,
                'description' => 'Allows to select vehicle trim for better matching',
            ],
        ];
    }
}
