<?php

namespace App\Console\Commands;

use App\Jobs\ProcessIncomingBookingJob;
use Illuminate\Console\Command;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Mtc\MercuryDataModels\Booking;
use Mtc\MercuryDataModels\BookingStatus;

class IngestBookings extends Command
{
    use DispatchesJobs;

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'bookings:ingest';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Process new incoming bookings';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        Booking::query()
            ->where('status', BookingStatus::PENDING)
            ->whereNull('ingested_at')
            ->get()
            ->each(fn(Booking $booking) => $this->dispatch(new ProcessIncomingBookingJob($booking)));

        return 0;
    }
}
