<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class FuzeySettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'CRM',
                'section' => 'Live Chat',
                'group' => 'Fuzey',
                'name' => 'Enabled',
                'config_key' => 'chat-fuzey-enabled',
                'type' => 'boolean',
                'value' => false,
                'order' => 0,
                'description' => '<a href="https://www.getfuzey.com/" target="_blank">Fuzey</a> chat integration.'
            ],
            [
                'tab' => 'CRM',
                'section' => 'Live Chat',
                'group' => 'Fuzey',
                'name' => 'Client ID',
                'config_key' => 'chat-fuzey-client_id',
                'type' => 'string',
                'value' => '',
                'order' => 1,
                'validation_rules' => [
                    "required_if:values.chat-fuzey-enabled,true"
                ]
            ],
        ];
    }
}
