<?php
return [
    'categories' => [
        'configuration' => 'Configuration',
        'frontend' => 'Frontend developer',
        'developer' => 'Backend developer',
        'marketing' => 'Marketing',
        'domains' => 'Domains',
    ],
    'names' => [
        'site_name' => 'Site name is set in settings',
        'site_email' => 'Site email is set in settings',
        'site_phone_number' => 'Primary phone number is set in settings',
        'apple_touch' => 'Apple touch icon is set in settings',
        'site_favicon' => 'Favicon is set in settings',
        'theme_domain' => 'Domains are pointing to custom theme correctly',
        'theme_env_prod_mode' => 'Theme .env values updated for production mode',
        'primary_domain' => 'Site domain is set and marked as primary',
        'form_email_recipients' => 'All forms send copies to client recipient emails',
        'crm_live_mode' => 'CRM integrations are not in test mode',
        'stock_on_site' => 'Vehicle stock is on site',
        'stock_has_finance' => 'Vehicle stock has finance examples',
        'finance_provider_functional' => 'Finance provider is set up and working',
        'stripe_test_mode' => 'Stripe payments use live keys',
        'specs_provider_ok' => 'Spec provider credentials are working',
        'valuation_provider_ok' => 'Valuation provider credentials are working',
        'analytics_configured' => 'Analytics/GTM configured in theme',
        'matomo_configured_settings' => 'Matomo site ID added in site configuration',
        'matomo_configured_theme' => 'Matomo configured in theme',
        'cloudflare_configured' => 'Cloudflare configured for site',
        'seo_data_imported' => 'SEO metadata imported and TESTED (:seo_data_count entries)',
        'redirects_imported' => 'SEO redirects imported and TESTED (:verified_redirects auto-verified / :seo_redirect_count total)',
        'userback_disabled' => 'Userback disabled on site',
    ],
    'descriptions' => [
        'site_name' => 'Settings > Site > General',
        'site_email' => 'Settings > Site > General',
        'site_phone_number' => 'Settings > Site > General',
        'apple_touch' => 'Settings > Site > General',
        'site_favicon' => 'Settings > Site > General',
        'theme_domain' => 'Applicable when site has a custom theme build. Requires domain to point correctly to theme in pm2 config. '
            . 'This requires setting correct domain name and triggering a UI code deployment after domain assignment.',
        'theme_env_prod_mode' => 'Needs to be done by team lead. Update .env values to allow indexing etc.',
        'primary_domain' => 'Main site domain (i.e. non-Autonomy subdomain) has been added and marked as primary domain',
        'form_email_recipients' => 'Checks all active forms to make sure recipients are not empty or mtc users',
        'crm_live_mode' => 'Checks if flags or keys are set to point to production',
        'stock_on_site' => 'Makes sure there is vehicles published on site',
        'stock_has_finance' => 'Checks if there are vehicles that do not have finance examples',
        'finance_provider_functional' => 'Checks if finance provider keys are working',
        'stripe_test_mode' => 'If Stripe is used, payments use live keys',
        'specs_provider_ok' => 'If used, tests to make sure specs requests work',
        'valuation_provider_ok' => 'If used, checks if api calls work as expected',
        'analytics_configured' => 'Analytics/GTM configured in theme',
        'matomo_configured_settings' => 'Matomo site ID added in site edit section',
        'matomo_configured_theme' => 'Matomo configured in theme .env file',
        'cloudflare_configured' => 'Cloudflare configured for site in site edit section',
        'seo_data_imported' => 'SEO metadata (titles/descriptions) are imported and tested to work as expected',
        'redirects_imported' => 'Website redirects are added in SEO section and verified to work as expected',
        'userback_disabled' => 'Userback token should be removed from settings to remove widget from site',
    ],
    'errors' => [
        'no-primary-domain' => 'No primary domain set',
        'primary-domain-points-to-temporary-domain' => 'Main domain points to temporary domain name :domain',
        'no-vehicle-for-finance-test' => 'No vehicle on site available for testing finance',
        'no-apple-touch-icon' => 'No Apple Touch Icon uploaded',
        'no-favicon' => 'No favicon uploaded',
        'no-email' => 'No primary email address in site settings',
        'no-site-name-set' => 'No site name set in settings',
        'no-phone-number' => 'No phone number set in settings',
        'no-stock-on-site' => 'No published vehicle stock on site',
        'no-live-stripe-public-key' => 'Stripe Public key missing or incorrect (not live key)',
        'no-live-stripe-private-key' => 'Stripe Private key missing or incorrect (not live key)',
        'no-spec-provider' => 'No spec provider found',
        'stock-missing-finance-examples' => 'Published vehicles without finance examples: :count / :total',
        'userback-token-still-active' => 'Userback token still is set. Please remove from settings',
        'matomo-id-missing' => 'Matomo ID missing. Please set in site edit screen',
        'cloudflare-not-enabled' => 'Cloudflare not enabled',
        'cloudflare-request-failed' => 'Cloudflare request failed with status :status',
        'valuation-not-retrieved' => 'Valuation was not retrieved',
    ],
];
