<?php

namespace Tests\Feature\Controllers;

use App\Models\ContentSync;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;
use Tests\UserForTenant;

class ContentSyncControllerTest extends TestCase
{
    use RefreshDatabase;
    use UserForTenant;

    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function testIndex()
    {
        ContentSync::factory(5)->create();
        $response = $this->actingAs($this->getUser())
            ->getJson(route('content-sync.index', [], false));

        $response->assertStatus(200);

        $this->assertIsArray($response->json());
        $this->assertEquals(5, $response->json('total'));
    }

    public function testShow()
    {
        $sync = ContentSync::factory()->create();
        $response = $this->actingAs($this->getUser())
            ->getJson(route('content-sync.show', $sync, false));

        $response->assertStatus(200);
        $this->assertArrayHasKey('tenant_id', $response->json());
        $this->assertArrayHasKey('user_id', $response->json());
    }

    public function testRenewToken()
    {

        $sync = ContentSync::factory()->create([
            'user_id' => $this->getUser()->id
        ]);
        $sync->created_at = now()->subDay();
        $this->assertEquals('Expired', $sync->status);

        $url = route('content-sync.renew-token', $sync, false);

        $response = $this->actingAs($this->getUser())
            ->postJson($url);

        $response->assertStatus(200);
        $this->assertArrayHasKey('tenant_id', $response->json());
        $this->assertArrayHasKey('user_id', $response->json());
        $this->assertArrayHasKey('status', $response->json());
        $this->assertEquals('Active', $response->json('status'));

        //Want to renew the token for another user - Permission Denied
        $sync->update([
            'user_id' => $this->getUser()->id + 1,
        ]);
        $response = $this->actingAs($this->getUser())
            ->postJson($url);

        $response->assertStatus(403);
    }
}
