<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Mtc\ContentManager\Models\MediaUse;
use Mtc\MercuryDataModels\VehicleOffer;

class OfferExport implements FromCollection, WithHeadings
{
    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        return VehicleOffer::query()
            ->with([
                'make',
                'model',
                'fuelType',
                'bodyStyle',
                'transmission',
                'drivetrain',
                'mediaUses.media',
                'dealership',
                'finance',
                'offerType',
                'franchise',
            ])
            ->get()
            ->map(function (VehicleOffer $offer) {
                // TODO: Export all finance examples
                $finance = $offer->finance->first();
                return [
                    'slug' => $offer->slug,
                    'name' => $offer->name,
                    'published' => $offer->published,
                    'featured' => $offer->featured,
                    'to_be_deleted' => '',
                    'franchise' => $offer->franchise?->name,
                    'dealership' => $offer->dealership?->name,
                    'new_car_type' => $offer->new_car_type,
                    'make' => $offer->make?->name,
                    'model' => $offer->model?->name,
                    'derivative' => $offer->derivative,
                    'trim' => $offer->trim,
                    'body_style' => $offer->bodyStyle?->name,
                    'fuel_type' => $offer->fuelType?->name,
                    'transmission' => $offer->transmission?->name,
                    'colour' => $offer->colour,
                    'engine_size_cc' => $offer->engine_size_cc,
                    'mpg' => $offer->mpg,
                    'key_features' => is_array($offer->key_features) ? implode(',', $offer->key_features) : [],
                    'description' => $offer->description,
                    'standard_spec' => is_array($offer->standard_spec) ? implode(',', $offer->standard_spec) : [],
                    'technical_spec' => is_array($offer->technical_spec) ? implode(',', $offer->technical_spec) : [],
                    'co2' => $offer->co2,
                    'price' => $offer->price,
                    'deposit' => $offer->deposit,
                    'monthly_price' => $finance->monthly_price ?? null,
                    'battery_range' => $offer->battery_range,
                    'battery_capacity_kwh' => $offer->battery_capacity_kwh,
                    'battery_usable_capacity_kwh' => $offer->battery_usable_capacity_kwh,
                    'battery_charge_time' => $offer->battery_charge_time,
                    'battery_quick_charge_time' => $offer->battery_quick_charge_time,
                    'battery_quick_charge_level' => $offer->battery_quick_charge_level,
                    'finance_type' => $finance->finance_type ?? null,
                    'term' => $finance->term ?? null,
                    'annual_mileage' => $finance->annual_mileage ?? null,
                    'customer_deposit' => $finance->customer_deposit ?? null,
                    'dealer_deposit_contribution' => $finance->dealer_deposit_contribution ?? null,
                    'full_price' => $finance->full_price ?? null,
                    'total_credit_amount' => $finance->total_credit_amount ?? null,
                    'option_to_purchase_fee' => $finance->option_to_purchase_fee ?? null,
                    'final_payment' => $finance->final_payment ?? null,
                    'total_amount' => $finance->total_amount ?? null,
                    'apr' => $finance->apr ?? null,
                    'excess_mileage_charge' => $finance->excess_mileage_charge ?? null,
                    'youtube_video' => $offer->youtube_video,
                    't_and_cs' => $offer->t_and_cs,
                    'drivetrain' => $offer->drivetrain?->name,
                    'type' => $offer->offerType?->slug,
                    'images' => $offer->mediaUses
                        ->map(fn(MediaUse $mediaUse) => $mediaUse->getUrl('large'))->implode('|'),
                    'first_payment' => $finance->first_payment ?? null,
                    'interest_rate' => $finance->interest_rate ?? null,
                    'number_of_payments' => $finance->number_of_payments ?? null,
                ];
            });
    }

    /**
     * Export file heading row
     *
     * @return string[]
     */
    public function headings(): array
    {
        return [
            'slug',
            'name',
            'published',
            'featured',
            'to_be_deleted',
            'franchise',
            'dealership',
            'new_car_type',
            'make',
            'model',
            'derivative',
            'trim',
            'body_style',
            'fuel_type',
            'transmission',
            'colour',
            'engine_size_cc',
            'mpg',
            'key_features',
            'description',
            'standard_spec',
            'technical_spec',
            'co2',
            'price',
            'deposit',
            'monthly_price',
            'battery_range',
            'battery_capacity_kwh',
            'battery_usable_capacity_kwh',
            'battery_charge_time',
            'battery_quick_charge_time',
            'battery_quick_charge_level',
            'finance_type',
            'term',
            'annual_mileage',
            'customer_deposit',
            'dealer_deposit_contribution',
            'full_price',
            'total_credit_amount',
            'option_to_purchase_fee',
            'final_payment',
            'total_amount',
            'apr',
            'excess_mileage_charge',
            'youtube_video',
            't_and_cs',
            'drivetrain',
            'type',
            'images',
            'first_payment',
            'interest_rate',
            'number_of_payments',
        ];
    }
}
