<?php

namespace App\Master\Models;

use Mtc\Crm\Traits\ModelSortAndFilter;
use Database\Factories\Master\Models\DrivetrainTypeFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Mtc\MercuryDataModels\Traits\EnsuresSlug;
use Mtc\MercuryDataModels\Traits\OrderByName;
use Stancl\Tenancy\Database\Concerns\CentralConnection;

class DrivetrainType extends Model
{
    use CentralConnection;
    use HasFactory;
    use OrderByName;
    use ModelSortAndFilter;
    use EnsuresSlug;

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'drivetrains';

    /**
     * Mass assign columns
     *
     * @var string[]
     */
    protected $fillable = [
        'name',
        'slug',
        'autotrader_id',
    ];

    /**
     * Columns shown in JSON response by default
     *
     * @var string[]
     */
    protected $visible = [
        'id',
        'slug',
        'name',
    ];

    protected static function boot()
    {
        parent::boot();

        self::saving(function (self $drivetrainType) {
            $drivetrainType->ensureSlug();
        });
    }

    /**
     * Model factory
     *
     * @return DrivetrainTypeFactory
     */
    protected static function newFactory()
    {
        return DrivetrainTypeFactory::new();
    }
}
