<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class BrandingOverrideSeeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Site',
                'section' => 'General',
                'group' => 'Branding - Email Template Overrides',
                'name' => 'Text Colour Override',
                'config_key' => 'app-text-colour-override',
                'type' => 'string',
                'value' => '',
                'description' => 'Primary text colour (e.g. titles) as a hex code. If set, this will OVERRIDE app-text-colour.',
                'order' => 1,
            ],
            [
                'tab' => 'Site',
                'section' => 'General',
                'group' => 'Branding - Email Template Overrides',
                'name' => 'Primary Colour Override',
                'config_key' => 'app-primary-colour-override',
                'type' => 'string',
                'value' => '',
                'description' => 'Primary colour as a hex code - #FF7823. If set, this will OVERRIDE app-primary-colour.',
                'order' => 1,
            ],
        ];
    }
}
