<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class CapEnrichDataSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Specification / Feature Synchronization',
                'group' => 'CAP',
                'name' => 'Enrich Vehicle Data with CAP info on CAP id lookup',
                'config_key' => 'vehicle-spec-providers-cap-enrich-data',
                'type' => 'boolean',
                'value' => false,
                'description' => 'When enabled will set Vehicle Type, Make, Model, First registration and door count '
                    . 'values based on info available on CAP network when performing CAP ID lookup',
                'order' => 30,
            ],
        ];
    }
}
