<?php

namespace Tests\Feature\Controllers;

use App\Tier;
use Database\Seeders\Global\PrimaryBillableSeed;
use Mtc\MercuryDataModels\Invoice;
use Mtc\MercuryDataModels\TenantBillingDetail;
use Tests\DatabaseTestCase;
use Tests\UserForTenant;

class BillingControllerTest extends DatabaseTestCase
{
    use UserForTenant;

    protected bool $withoutMiddlewares = true;

    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function testGetBillingDetails()
    {
        $response = $this->get(route('tenant.settings.billing.index'));
        $response->assertStatus(200);
    }

    public function testSetFirstBillingDetails()
    {
        $response = $this->actingAs($this->getUser(false))
            ->putJson(route('tenant.settings.billing.update-details'), [
                'vat_rate' => Invoice::REGULAR_VAT,
                'contact_no' => '00123123',
                'billing_email' => 'test@example.com',
                'first_name' => 'Peter',
                'last_name' => 'Parker',
                'address1' => 'ABC',
                'city' => 'Riga',
                'postcode' => 'LV1001',
                'country' => 'LV',
            ]);

        $response->assertStatus(200);
        $this->assertEquals(Invoice::REGULAR_VAT, $response->json('vat_rate'));
        $this->assertEquals('00123123', $response->json('contact_no'));
        $this->assertEquals('test@example.com', $response->json('billing_email'));
        $this->assertEquals('Peter', $response->json('first_name'));
        $this->assertEquals('Parker', $response->json('last_name'));
        $this->assertEquals('ABC', $response->json('address1'));
        $this->assertEquals('Riga', $response->json('city'));
        $this->assertEquals('LV1001', $response->json('postcode'));
        $this->assertEquals('LV', $response->json('country'));
    }


    public function testUpdateBillingDetails()
    {
        TenantBillingDetail::factory()->create(['tenant_id' => tenant('id')]);

        $response = $this->actingAs($this->getUser(false))
            ->putJson(route('tenant.settings.billing.update-details'), [
                'vat_rate' => Invoice::REGULAR_VAT,
                'contact_no' => '00123123',
                'billing_email' => 'test@example.com',
                'first_name' => 'Peter',
                'last_name' => 'Parker',
                'address1' => 'ABC',
                'city' => 'Riga',
                'postcode' => 'LV1001',
                'country' => 'LV',
            ]);

        $response->assertStatus(200);
        $this->assertEquals(Invoice::REGULAR_VAT, $response->json('vat_rate'));
        $this->assertEquals('00123123', $response->json('contact_no'));
        $this->assertEquals('test@example.com', $response->json('billing_email'));
        $this->assertEquals('Peter', $response->json('first_name'));
        $this->assertEquals('Parker', $response->json('last_name'));
        $this->assertEquals('ABC', $response->json('address1'));
        $this->assertEquals('Riga', $response->json('city'));
        $this->assertEquals('LV1001', $response->json('postcode'));
        $this->assertEquals('LV', $response->json('country'));
    }

    public function testUpdateSubscriptionType()
    {
        (new PrimaryBillableSeed())->run();
        TenantBillingDetail::factory()->create(['tenant_id' => tenant('id')]);
        tenant()->update([
            'tier' => Tier::LITE->value
        ]);

        $response = $this->actingAs($this->getUser(false))
            ->putJson(route('tenant.settings.billing.update-subscription'), [
                'tier' => Tier::STANDARD->value,
            ]);

        $response->assertStatus(200);
    }
}
