<?php

namespace Tests\Feature\Controllers;

use Mtc\MercuryDataModels\Invoice;
use Tests\DatabaseTestCase;
use Tests\UserForTenant;

class InvoiceControllerTest extends DatabaseTestCase
{
    use UserForTenant;

    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function testGetInvoices()
    {
        Invoice::factory(4)->create(['tenant_id' => tenant('id')]);
        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->get(route('tenant.invoices.index'));
        $response->assertStatus(200);
        $this->assertArrayHasKey('data', $response->json());
        $this->assertIsArray($response->json('data'));
        $this->assertCount(4, $response->json('data'));
    }

    public function testViewInvoice()
    {
        $invoice = Invoice::factory()->create(['tenant_id' => tenant('id')]);

        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->get(route('tenant.invoices.show', $invoice));

        $response->assertStatus(200);
        $this->assertEquals($invoice->id, $response->json('id'));
        $this->assertEquals($invoice->amount, $response->json('amount'));

    }
}
