<?php

namespace Tests\Feature\Controllers;

use App\Tier;
use Mtc\MercuryDataModels\User;
use Tests\DatabaseTestCase;
use Tests\UserForTenant;

class UserControllerTest extends DatabaseTestCase
{
    use UserForTenant;

    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function testShow()
    {
        tenant()->update(['tier' => Tier::LITE->value]);

        $response = $this->actingAs($this->getUser())
            ->getJson(route('users.show', [], false));

        $response->assertStatus(200);
        $this->assertEquals($this->user->email, $response->json('email'));
        $this->assertEquals(Tier::LITE->value, $response->json('tier'));
        $this->assertArrayHasKey('tenants', $response->json());
        $this->assertArrayHasKey('roles', $response->json());
    }

    public function testSiteUsers()
    {
        $users = User::factory(5)->create();
        tenant()->users()->attach($users);

        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->getJson(route('tenant.users.index', [], false));

        $response->assertStatus(200);
        $this->assertIsArray($response->json('data'));
        $this->assertArrayHasKey('limit', $response->json('data'));
        $this->assertCount(6, $response->json('data.users'));
    }

    public function testSetSite()
    {
        $user = User::factory()->create();

        $url = route('users.set-site', [], false);
        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->postJson($url, [
                'selected_site' => tenant('id')
            ]);


        $response->assertStatus(200);
        $this->assertTrue(in_array('mtc', $response->json()));

        $response = $this->actingAs($user)
            ->withHeader('X-Tenant', tenant('id'))
            ->postJson($url, [
                'selected_site' => tenant('id')
            ]);

        $this->assertCount(0, $response->json());
    }
}
