<?php

namespace Tests\Feature;

use App\Actions\Fortify\CreateNewUser;
use Illuminate\Validation\ValidationException;
use Mtc\MercuryDataModels\User;
use Tests\DatabaseTestCase;

class CreateNewUserTest extends DatabaseTestCase
{

    /**
     * A basic unit test example.
     *
     * @return void
     */
    public function testCreateUser()
    {
        $input = [
            'name' => 'John Doe',
            'email' => 'test@example.com',
            'password' => 'SomethingSuperStrong2#',
            'password_confirmation' => 'SomethingSuperStrong2#',
        ];

        $user = (new CreateNewUser())->create($input);

        $this->assertInstanceOf(User::class, $user);
        $this->assertEquals('John Doe', $user->name);
        $this->assertEquals('test@example.com', $user->email);
        $this->assertTrue(password_verify('SomethingSuperStrong2#', $user->password));
    }

    public function testFailsWithoutRequiredFields()
    {
        $input = [
            'email' => 'test@example.com',
            'password' => 'SomethingSuperStrong2#',
            'password_confirmation' => 'SomethingSuperStrong2#',
        ];

        $this->expectException(ValidationException::class);
        $user = (new CreateNewUser())->create($input);

        $input = [
            'name' => 'John Doe',
            'password' => 'SomethingSuperStrong2#',
            'password_confirmation' => 'SomethingSuperStrong2#',
        ];

        $this->expectException(ValidationException::class);
        $user = (new CreateNewUser())->create($input);

        $input = [
            'name' => 'John Doe',
            'email' => 'test@example.com',
            'password' => 'SomethingSuperStrong2#',
        ];

        $this->expectException(ValidationException::class);
        $user = (new CreateNewUser())->create($input);
    }
}
