<?php

namespace Tests\Feature;

use App\Exports\EbayMotorsExport;
use App\Facades\Settings;
use Mtc\MercuryDataModels\Vehicle;
use Tests\DatabaseTestCase;
use Tests\UserForTenant;


class EbayMotorsExportTest extends DatabaseTestCase
{
    use UserForTenant;

    public function testData()
    {
        Settings::make([
            'tab' => 'foo-baz',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'ebay enabled',
            'config_key' => 'sales-channels-ebay-motors-enabled',
            'value' => true,
            'type' => 'boolean',
        ]);

        Vehicle::factory()->create([
            'is_published' => true,
            'description' => 'foo',
            'type' => 'car',
        ]);

        $vehicles = (new EbayMotorsExport())->collection();

        $this->assertCount(1, $vehicles);

        $vehicle = $vehicles->first();

        $this->assertEquals('foo', $vehicle['Description']);
        $this->assertEquals(0, $vehicle['PricePlusVat']);
    }

    public function testSanitisedDescription()
    {
        Settings::make([
            'tab' => 'foo-baz',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'ebay enabled',
            'config_key' => 'sales-channels-ebay-motors-enabled',
            'value' => true,
            'type' => 'boolean',
        ]);

        // set expected string, testing full range of allowable characters
        $expected_string = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.,?!/()\\[]"\'-_+=@£€$%^&*';

        // add characters that we want to exclude from feed
        $description = '<p>â ðŸ“§ ðŸ“± ðŸŽ¶</p>' . $expected_string;

        Vehicle::factory()->create([
            'is_published' => true,
            'description' => $description,
            'type' => 'car',
        ]);

        $vehicles = (new EbayMotorsExport())->collection();

        $this->assertCount(1, $vehicles);

        $vehicle = $vehicles->first();

        // assert that we have the vehicle with the expected description (including additional characters) in the db
        $this->assertCount(1, Vehicle::query()->where('description', $description)->get());

        // assert that the feed contains the sanitised description
        $this->assertEquals($expected_string, $vehicle['Description']);
    }
}
