<?php

namespace Tests\Feature;

use App\Master\Models\BodyStyleType;
use App\Master\Models\DrivetrainType;
use App\Master\Models\FuelType;
use App\Master\Models\TransmissionType;
use App\Master\Models\VehicleMake;
use App\Master\Models\VehicleModel;
use Tests\DatabaseTestCase;
use Tests\UserForTenant;

class MasterTaxonomyModelTest extends DatabaseTestCase
{
    use UserForTenant;

    public function testModels()
    {
        $bodyStyle = BodyStyleType::factory()->create();
        $this->assertTrue($bodyStyle->exists);

        $drivetrain = DrivetrainType::factory()->create();
        $this->assertTrue($drivetrain->exists);

        $fuelType = FuelType::factory()->create();
        $this->assertTrue($fuelType->exists);

        $transmission = TransmissionType::factory()->create();
        $this->assertTrue($transmission->exists);

        $make = VehicleMake::factory()->create();
        $this->assertTrue($make->exists);

        $model = VehicleModel::factory()->create(['make_id' => $make->id]);
        $this->assertTrue($model->exists);
        $this->assertTrue($model->make->is($make));
        $this->assertTrue(VehicleModel::query()->ofMake($make->id)->exists());
    }
    public function testMakeAttributes()
    {

        $make = VehicleMake::factory()->create([
            'logo' => 'foo.png',
            'monochrome_logo' => 'baz.png',
        ]);

        $image = $make->image;
        $this->assertIsArray($image);
        $this->assertArrayHasKey('alt', $image);
        $this->assertArrayHasKey('src', $image);
        $this->assertIsArray($make->logo);
        $this->assertArrayHasKey('path', $make->logo);
        $this->assertArrayHasKey('url', $make->logo);
        $this->assertIsArray($make->monochrome_logo);
        $this->assertArrayHasKey('path', $make->monochrome_logo);
        $this->assertArrayHasKey('url', $make->monochrome_logo);
    }
}
