<?php

namespace Tests\Feature;

use App\Console\Commands\NotifyOverdueInvoices;
use App\Mail\OverdueInvoiceNotification;
use Carbon\Carbon;
use Illuminate\Support\Facades\Event;
use Illuminate\Support\Facades\Mail;
use Mtc\MercuryDataModels\Invoice;
use Mtc\MercuryDataModels\Tenant;
use Stancl\Tenancy\Events\TenantCreated;
use Tests\DatabaseTestCase;

class NotifyOverdueInvoicesTest extends DatabaseTestCase
{
    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function testNoNotifications(): void
    {
        Mail::fake();
        $this->artisan(NotifyOverdueInvoices::class);

        Mail::assertNothingSent();
    }

    public function testHasNotifications(): void
    {
        Event::fake([
            TenantCreated::class
        ]);
        $tenant = Tenant::factory()->create();
        Invoice::factory()->create([
            'paid_at' => null,
            'due_at' => Carbon::now()->subDays(40),
            'tenant_id' => $tenant->id,
        ]);

        Mail::fake();
        $this->artisan(NotifyOverdueInvoices::class);

        Mail::assertQueued(OverdueInvoiceNotification::class);
    }
}
