<?php

namespace Tests\Feature;

use App\Master\Models\VehicleMake;
use App\Master\Models\VehicleModel;
use Database\Seeders\Global\OpelGrandlandSeeder;
use Database\Seeders\Global\OpelVanSeeder;
use Illuminate\Support\Facades\Storage;
use Tests\DatabaseTestCase;

class VehicleTest extends DatabaseTestCase
{

    public function testOpelModelSeeder()
    {
        $make = VehicleMake::query()->create([
            'slug' => 'opel',
            'name' => 'Opel',
        ]);
        $this->seed(OpelVanSeeder::class);
        $this->seed(OpelGrandlandSeeder::class);
        $this->assertCount(4, VehicleModel::query()->where('make_id', $make->id)->get());
        $this->assertCount(1, VehicleModel::query()->where('slug', 'combo')->get());
        $this->assertCount(1, VehicleModel::query()->where('slug', 'movano')->get());
        $this->assertCount(1, VehicleModel::query()->where('slug', 'vivaro')->get());
        $this->assertCount(1, VehicleModel::query()->where('slug', 'grandland')->get());
    }
}
