<?php

namespace Tests\Tenant;

use Mtc\MercuryDataModels\CarConfiguratorPackage;
use Tests\TenantTestCase;
use Tests\UserForTenant;

class CarConfiguratorPackageControllerTest extends TenantTestCase
{
    use UserForTenant;

    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function testIndex()
    {
        CarConfiguratorPackage::factory(3)->create();

        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->getJson(route('tenant.car-configurator-packages.index'));

        $response->assertStatus(200);
        $this->assertIsArray($response->json('data'));
        $this->assertCount(3, $response->json('data'));
    }

    public function testStore()
    {
        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->postJson(route('tenant.car-configurator-packages.store'), [
                'name' => 'foo'
            ]);

        $response->assertStatus(201);
        $this->assertEquals('foo', $response->json('name'));
        $this->assertTrue(CarConfiguratorPackage::query()->where('name', 'foo')->exists());

    }

    public function testUpdate()
    {
        $package = CarConfiguratorPackage::factory()->create(['name' => 'foo']);

        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->putJson(route('tenant.car-configurator-packages.update', $package->id), [
                'name' => 'baz',
                'description' => 'lorem ipsum dolor',
                'category' => 'foo faz',
                'price' => 123.00,
            ]);

        $package->refresh();
        $response->assertStatus(200);
        $this->assertEquals('baz', $package->name);
        $this->assertEquals('lorem ipsum dolor', $package->description);
        $this->assertEquals('foo faz', $package->category);
        $this->assertEquals(123.00, $package->price);

    }

    public function testShow()
    {
        $package = CarConfiguratorPackage::factory()->create(['name' => 'foo']);

        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->getJson(route('tenant.car-configurator-packages.show', $package->id));

        $response->assertStatus(200);
        $this->assertEquals($package->id, $response->json('id'));
        $this->assertEquals('foo', $response->json('name'));

    }

    public function testDelete()
    {
        $package = CarConfiguratorPackage::factory()->create(['name' => 'foo']);
        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->deleteJson(route('tenant.car-configurator-packages.destroy', $package->id));

        $response->assertStatus(200);
        $this->assertFalse(CarConfiguratorPackage::query()->where('id', $package->id)->exists());
    }
}
