<?php

namespace Tests\Tenant;

use App\Modules\Sales\Services\CodeWeavers;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\MercuryDataModels\VehicleFinance;
use Tests\TenantTestCase;

class CodeWeaversEcommerceTest extends TenantTestCase
{
    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function testGetEcommerceData()
    {
        $vehicle = Vehicle::factory()->create(['monthly_price' => 123]);
        VehicleFinance::factory()->create([
            'vehicle_id' => $vehicle->id,
            'provider' => 'codeweavers',
            'monthly_price' => 123,
            'apply_url' => 'http://foo.baz/bar'
        ]);

        $response = (new CodeWeavers())->ecommerceData($vehicle);
        $this->assertEquals('http://foo.baz/bar', $response['url']);
    }
}
