<?php

namespace Tests\Tenant;

use App\Jobs\AutomaticallyMapColours;
use Mtc\MercuryDataModels\Colour;
use Mtc\MercuryDataModels\ColourMap;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\MercuryDataModels\VehicleOffer;
use Tests\TenantTestCase;

class ColourMapJobTest extends TenantTestCase
{
    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function testIndex()
    {
        Colour::query()->delete();
        ColourMap::query()->delete();

        $blue = Colour::factory()->create(['colour' => 'blue']);
        $yellow = Colour::factory()->create(['colour' => 'yellow']);
        Vehicle::factory()->create(['colour' => null]);
        Vehicle::factory()->create(['colour' => 'sky blue']);
        Vehicle::factory()->create(['colour' => 'acid yellow']);
        VehicleOffer::factory()->create(['colour' => 'striped blue']);

        (new AutomaticallyMapColours())->handle();

        $this->assertTrue(ColourMap::query()->where(['colour_id' => $blue->id, 'sub_colour' => 'sky blue'])->exists());
        $this->assertTrue(ColourMap::query()->where(['colour_id' => $yellow->id, 'sub_colour' => 'acid yellow'])->exists());
        $this->assertTrue(ColourMap::query()->where(['colour_id' => $blue->id, 'sub_colour' => 'striped blue'])->exists());
    }
}
