<?php

namespace Tests\Tenant;

use Mtc\MercuryDataModels\Colour;
use Mtc\MercuryDataModels\Vehicle;
use Tests\TenantTestCase;
use Tests\UserForTenant;

class ColourMapTest extends TenantTestCase
{
    use UserForTenant;


    public function testIndex()
    {
        Colour::query()->delete();

        $colour = Colour::factory()->create();
        Colour::factory(3)->create();
        Vehicle::factory()->create(['colour' => 'foo']);
        Vehicle::factory(2)->create(['colour' => 'baz']);
        $colour->mappedColours()->create(['sub_colour' => 'foo']);

        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->getJson(route('tenant.colour-map.index'));

        $response->assertStatus(200);

        $this->assertArrayHasKey('colours', $response->json());
        $this->assertCount(4, $response->json('colours'));
        $this->assertArrayHasKey('id', $response->json('colours.0'));
        $this->assertArrayHasKey('colour', $response->json('colours.0'));
        $this->assertArrayHasKey('hex_code', $response->json('colours.0'));
        $this->assertArrayHasKey('subColours', $response->json('colours.0'));
        $this->assertTrue(collect($response->json('colours'))->where('colour', $colour->colour)->count() > 0);
        $colourResponse = collect($response->json('colours'))->where('id', $colour->id)->first();
        $this->assertTrue(collect($colourResponse['subColours'])->where('name', 'foo')->count() == 1);

        $this->assertArrayHasKey('subColours', $response->json());
        $this->assertCount(1, $response->json('subColours'));
        $this->assertArrayHasKey('name', $response->json('subColours.0'));
    }

    public function testUpdate()
    {
        Colour::factory()->create();
        $colour = Colour::factory()->create();
        Vehicle::factory()->create(['colour' => 'foo']);

        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->putJson(route('tenant.colour-map.update'), [
                'colours' => [
                    [
                        'id' => $colour->id,
                        'colour' => 'foo baz',
                        'hex_code' => 'ABC123',
                        'subColours' => [
                            ['name' => 'foo'],
                        ],
                    ],
                    [
                        'id' => 'abc12312aa',
                        'colour' => 'lorem ipsum',
                        'hex_code' => null,
                        'subColours' => [],
                    ],
                ]
            ]);

        $response->assertStatus(200);
        $this->assertTrue(collect($response->json('colours'))->where('colour', 'lorem ipsum')->count() > 0);
        $colourResponse = collect($response->json('colours'))->where('id', $colour->id)->first();
        $this->assertEquals('foo baz', $colourResponse['colour']);
        $this->assertTrue(collect($colourResponse['subColours'])->where('name', 'foo')->count() == 1);
    }
}
