<?php

namespace Tests\Tenant;

use App\Facades\Settings;
use App\Modules\Lookup\Config\AutoTraderConfig;
use App\Modules\Lookup\Config\BCAConfig;
use App\Modules\Lookup\Contracts\VehicleLookupData;
use Illuminate\Support\Facades\App;
use Tests\TenantTestCase;

class LookupObjectUnitTest extends TenantTestCase
{
    public function testLookupData()
    {
        $data = (new VehicleLookupData('BMW', '330i', 'foo', 'faz', 'bar', 'baz'))->toArray();

        $this->assertEquals('BMW', $data['make']);
        $this->assertEquals('330i', $data['model']);
        $this->assertEquals('foo', $data['generation']);
        $this->assertEquals('faz', $data['derivative']);
        $this->assertEquals('bar', $data['trim']);
        $this->assertEquals('baz', $data['body_type']);
    }

    public function testAutoTraderConfig()
    {
        Settings::update('valuation-auto-trader-enabled', true);
        Settings::update('auto-trader-advertiser-id', 123);

        $this->assertTrue((new AutoTraderConfig())->enabled());
        $this->assertEquals(123, (new AutoTraderConfig())->merchantId());
    }
    public function testBCAConfig()
    {
        Settings::update('lookup-bca-enabled', true);
        Settings::update('lookup-bca-api_key', 123);
        Settings::update('lookup-bca-api_secret', 222);

        $bca = App::make(BCAConfig::class);
        $this->assertTrue($bca->enabled());
        $this->assertEquals(123, $bca->apiKey());
        $this->assertEquals(222, $bca->apiSecret());
    }
}
