<?php

namespace Tests\Tenant;

use Mtc\MercuryDataModels\Replacement;
use Tests\TenantTestCase;
use Tests\UserForTenant;

class ReplacementControllerTest extends TenantTestCase
{
    use UserForTenant;

    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function testIndex()
    {
        Replacement::factory(3)->create();

        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->getJson(route('tenant.settings.replacements.show'));

        $response->assertStatus(200);
        $this->assertIsArray($response->json('data.replacements'));
        $this->assertCount(3, $response->json('data.replacements'));
    }

    public function testStore()
    {
        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->postJson(route('tenant.settings.replacements.store'), [
                'original' => 'foo',
                'replacement' => 'faz',
                'type' => 'global',
            ]);

        $response->assertStatus(200);
        $this->assertTrue(Replacement::query()->where('original', 'foo')->exists());

    }

    public function testUpdate()
    {
        $replacement = Replacement::factory()->create([
            'original' => 'foo',
            'replacement' => 'faz',
            'type' => 'global',
        ]);

        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->putJson(route('tenant.settings.replacements.update', $replacement->id), [
                'original' => 'faz',
                'replacement' => 'baz',
                'type' => 'global',
            ]);

        $replacement->refresh();
        $response->assertStatus(200);
        $this->assertEquals('faz', $replacement->original);
        $this->assertEquals('baz', $replacement->replacement);

    }


    public function testDelete()
    {
        $replacement = Replacement::factory()->create([
            'original' => 'foo',
            'replacement' => 'faz',
            'type' => 'global',
        ]);
        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->deleteJson(route('tenant.settings.replacements.destroy', $replacement->id));

        $response->assertStatus(200);
        $this->assertFalse(Replacement::query()->where('id', $replacement->id)->exists());
    }
}
