<?php

namespace Tests\Tenant;

use App\Facades\Feature;
use App\Facades\Settings;
use Carbon\Carbon;
use Mtc\MercuryDataModels\Setting;
use Tests\TenantTestCase;

class SettingRepositoryTest extends TenantTestCase
{
    protected bool $useTestSettingRepository = false;

    public function testLoadSettingValue()
    {
        Setting::factory()->create([
            'tab' => 'foo-baz',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'dolor',
            'config_key' => 'foo',
            'type' => 'string',
            'value' => 'baz',
        ]);

        $this->assertEquals('baz', Settings::get('foo'));
    }

    public function testDefaultValue()
    {
        $this->assertEquals('baz', Settings::get('lorem-ipsum', 'baz'));
    }

    public function testFeatureFlagsOnSettings()
    {
        Feature::setEnabled(tenant(), ['imagin-studio-placeholders']);
        Settings::make([
            'tab' => 'foo-baz',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'dolor',
            'config_key' => 'foo',
            'value' => true,
            'type' => 'boolean',
        ]);
        Settings::make([
            'tab' => 'foo-baz',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'dolor',
            'config_key' => 'faz',
            'feature' => 'imagin-studio-placeholders',
            'value' => true,
            'type' => 'boolean',
        ]);
        Settings::make([
            'tab' => 'foo-baz',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'dolor',
            'config_key' => 'baz',
            'feature' => 'valuation_adjustments',
            'value' => true,
            'type' => 'boolean',
        ]);

        $this->assertTrue(Settings::get('foo'));
        $this->assertTrue(Settings::get('faz'));
        $this->assertNull(Settings::get('baz'));

    }

    public function testSettingValueCasting()
    {
        Settings::make([
            'tab' => 'foo-baz',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'dolor',
            'config_key' => 'foo',
            'value' => 'baz',
            'type' => 'string',
        ]);

        Settings::make([
            'tab' => 'foo-baz',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'dolor',
            'config_key' => 'foo-baz',
            'value' => '1',
            'type' => 'int',
        ]);

        Settings::make([
            'tab' => 'foo-baz',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'dolor',
            'config_key' => 'foo-bar',
            'value' => '1',
            'type' => 'bool',
        ]);

        Settings::make([
            'tab' => 'foo-baz',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'dolor',
            'config_key' => 'foo-baz-bar',
            'value' => '1.2',
            'type' => 'float',
        ]);

        Settings::make([
            'tab' => 'foo-baz',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'dolor',
            'config_key' => 'foo-bar-baz',
            'value' => '2022-01-13',
            'type' => 'datetime',
        ]);

        Settings::make([
            'tab' => 'foo-baz',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'dolor',
            'config_key' => 'secret-foo',
            'value' => 'foo baz bar',
            'type' => 'secret',
        ]);

        $this->assertEquals('baz', Settings::get('foo'));

        $this->assertIsInt(Settings::get('foo-baz'));
        $this->assertEquals(1, Settings::get('foo-baz'));

        $this->assertIsBool(Settings::get('foo-bar'));
        $this->assertEquals(true, Settings::get('foo-bar'));

        $this->assertIsFloat(Settings::get('foo-baz-bar'));
        $this->assertEquals(1.2, Settings::get('foo-baz-bar'));

        $this->assertInstanceOf(Carbon::class, Settings::get('foo-bar-baz'));
        $this->assertEquals(Carbon::parse('2022-01-13'), Settings::get('foo-bar-baz'));

        $this->assertEquals('foo baz bar', Settings::get('secret-foo'));
    }
}
