<?php

namespace Tests\Tenant;

use App\Facades\Settings;
use App\Facades\Site;
use App\SiteRepository;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\MercuryDataModels\VehicleOffer;
use Tests\TenantTestCase;

final class SiteRepositoryWwwTest extends TenantTestCase
{
    protected bool $useTestSettingRepository = false;

    protected function setUp(): void
    {
        parent::setUp();

        // Override the baseUrl mock to handle the www parameter
        $this->partialMock(SiteRepository::class, function ($mock) {
            $mock->shouldReceive('baseUrl')->andReturnUsing(function (?bool $includeWww = false) {
                return $includeWww ? 'http://www.foo.localhost' : 'http://foo.localhost';
            });
        });
    }

    public function testVehicleUrlWithWww()
    {
        Settings::make([
            'tab' => 'Automotive',
            'section' => 'General',
            'group' => 'General',
            'name' => 'Include www in vehicle page URL path',
            'config_key' => 'url-path-include-www',
            'type' => 'boolean',
            'value' => true,
        ]);

        $this->assertStringContainsString('www.', Site::vehicleUrl(Vehicle::factory()->create()));
    }

    public function testOfferUrlWithWww()
    {
        Settings::make([
            'tab' => 'Automotive',
            'section' => 'General',
            'group' => 'General',
            'name' => 'Include www in offer page URL path',
            'config_key' => 'url-path-include-www',
            'type' => 'boolean',
            'value' => true,
        ]);

        $offer = VehicleOffer::factory()->create();

        $url = Site::offerUrl($offer, true);

        $this->assertStringContainsString($offer->urlPath(), $url);
        $this->assertStringContainsString('www.', $url);
    }
}
