<?php

namespace Tests\Tenant;

use App\VehicleTrimRepository;
use Mtc\MercuryDataModels\VehicleTrim;
use Tests\TenantTestCase;

class VehicleTrimRepositoryTest extends TenantTestCase
{
    public function testImportRecord()
    {
        $repository = (new VehicleTrimRepository());

        $this->assertFalse(VehicleTrim::query()->where('make_id', 1)->where('model_id', 2)->exists());
        $imported = $repository->importRecord([
            'name' => 'foo',
            'new_car_id' => 1,
            'make_id' => 1,
            'model_id' => 2,
            'description' => 'faz',
            'full_price' => 12344,
        ]);
        $this->assertTrue($imported);
        $this->assertTrue(VehicleTrim::query()->where('make_id', 1)->where('model_id', 2)->exists());
    }

    public function testCanBeImported()
    {
        $repository = (new VehicleTrimRepository());

        $this->assertTrue($repository->canBeImported(['name' => 'foo']));

        VehicleTrim::query()->create([
            'name' => 'foo',
            'make_id' => 1,
            'model_id' => 2,
            'new_car_id' => 3,
        ]);

        $this->assertFalse($repository->canBeImported(['name' => 'foo']));
    }

    public function testExportToRemote()
    {
        $repository = (new VehicleTrimRepository());

        $this->assertEmpty($repository->exportToRemote([]));

        $trim = VehicleTrim::query()->create([
            'name' => 'foo',
            'make_id' => 1,
            'model_id' => 2,
            'new_car_id' => 3,
        ]);

        $this->assertEmpty($repository->exportToRemote([]));
        $export = $repository->exportToRemote([$trim->id]);
        $this->assertNotEmpty($export);
        $this->assertEquals(1, count($export));
        $this->assertEquals($trim->name, $export[0]['name']);
    }

    public function testCheckImportEntryValidity()
    {

        $repository = (new VehicleTrimRepository());
        $check = $repository->checkImportEntryValidity(['name' => 'foo'], []);
        $this->assertEmpty($check['errors']);

        VehicleTrim::query()->create([
            'name' => 'foo',
            'make_id' => 1,
            'model_id' => 2,
            'new_car_id' => 3,
        ]);
        $check = $repository->checkImportEntryValidity(['name' => 'foo'], []);
        $this->assertNotEmpty($check['errors']);
    }
}
