<?php

namespace App\Modules\VehicleLabels\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Mtc\MercuryDataModels\Franchise;
use Mtc\MercuryDataModels\Label;

class LabelList extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $this->resource->through(fn(Label $label) => [
            'title' => $label->name,
            'link' => '/manage-content/labels/edit/' . $label->id,
            'id' => $label->id,
            'active' => (bool)$label->active,
            'metaItems' => [
                'category' => $label->category,
                'franchise' => Franchise::query()
                    ->where('id', '=', $label->franchise_id)
                    ->first()
                    ->name ?? '',
            ]
        ]);

        $data = $this->resource->toArray();

        $data['view_columns'] = [
            [
                'id' => 'category',
                'name' => 'Category',
                'icon' => '',
            ],
            [
                'id' => 'franchise',
                'name' => 'Franchise',
                'icon' => '',
            ]
        ];

        $data['default_columns'] = [
            'category',
            'franchise',
        ];

        return $data;
    }
}
