<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class PinewoodSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'Pinewood',
                'name' => 'Enabled',
                'config_key' => 'stock-pinewood-enabled',
                'type' => 'boolean',
                'min_tier' => 'standard',
                'value' => false,
                'description' => '<a href="https://www.pinewood.co.uk/" target="_blank">Pinewood DMS</a> sync integration.'
                    . ' When enabled, will also add extra field against dealerships for mapping locations.',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'Pinewood',
                'name' => 'Synchronize new vehicles',
                'config_key' => 'stock-pinewood-sync-new-vehicles',
                'type' => 'boolean',
                'min_tier' => 'standard',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'Pinewood',
                'name' => 'Synchronize used vehicles',
                'config_key' => 'stock-pinewood-sync-used-vehicles',
                'type' => 'boolean',
                'min_tier' => 'standard',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'Pinewood',
                'name' => 'Only import vehicles with price set',
                'config_key' => 'stock-pinewood-sync-with-price',
                'type' => 'boolean',
                'min_tier' => 'standard',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'Pinewood',
                'name' => 'Synchronize images',
                'config_key' => 'stock-pinewood-sync-images',
                'type' => 'boolean',
                'min_tier' => 'standard',
                'value' => true,
                'description' => 'Retrieve images from DMS and add them to vehicles when importing'
            ],
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'Pinewood',
                'name' => 'Only sync vehicles with internet price set',
                'config_key' => 'stock-pinewood-sync-only-with-internet-price',
                'type' => 'boolean',
                'min_tier' => 'standard',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'Pinewood',
                'name' => 'API Username',
                'config_key' => 'stock-pinewood-username',
                'type' => 'string',
                'min_tier' => 'standard',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.stock-pinewood-enabled,true"
                ]
            ],
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'Pinewood',
                'name' => 'API Password',
                'config_key' => 'stock-pinewood-password',
                'type' => 'secret',
                'min_tier' => 'standard',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.stock-pinewood-enabled,true"
                ]
            ],
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'Pinewood',
                'name' => 'Verify integration',
                'config_key' => 'stock-pinewood-verify',
                'type' => 'verify',
                'min_tier' => 'standard',
                'value' => false,
            ],
        ];
    }
}
