<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;
use Mtc\MercuryDataModels\Setting;

class ProductsFinanceRiskBasedPricingSettingsSeed extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $general = [
            [
                'group' => 'General',
                'config_key' => 'finance-risk-based-pricing-enabled',
            ],
            [
                'group' => 'General',
                'config_key' => 'finance-risk-based-pricing-allow-electric',
            ],
            [
                'group' => 'General',
                'config_key' => 'finance-risk-based-pricing-enable-finance-options',
            ],
            [
                'group' => 'General',
                'config_key' => 'finance-risk-based-pricing-finance-options',
            ],
        ];

        collect($general)->each(function ($setting) {
            Setting::where('config_key', $setting['config_key'])
                ->update(['group' => $setting['group']]);
        });

        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'CodeWeavers',
                'name' => 'Finance Use Products Risk Based Pricing',
                'config_key' => 'finance-use-products-risk-based-pricing',
                'min_tier' => 'pro',
                'type' => 'boolean',
                'value' => false,
                'description' => 'Depends on how finance is integrated',
            ]
        ];
    }
}
