<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>Invoice #{{ $invoice->id }}</title>

    <link rel="stylesheet" type="text/css" href="/public/css/print_invoice.css" />
</head>
<body class="antialiased">

<header>

{{--    <div class="logo">--}}
{{--        <img src="{{ settings.THEME_PATH }}/images/logo.png" alt="{{ config('app.name') }}" />--}}
{{--    </div>--}}

    <table class="orderSummaryDetails">
        <tr>
            <th>Invoice No.:</th>
            <td>
                <strong>
                    {{ $invoice->id }}
                </strong>
            </td>
        </tr>
    </table>

</header>

<table>
    <tr>
        <td class="clientDetails">
            <h3>Seller</h3>
            <p>
                <strong>
                    {{ $invoice->sellerAddress->first_name }}
                    {{ $invoice->sellerAddress->last_name }}
                </strong><br/>
                {{ $invoice->sellerAddress->address1 }}<br/>
                {{ $invoice->sellerAddress->address2 }}<br/>
                {{ $invoice->sellerAddress->city }}<br/>
                {{ $invoice->sellerAddress->postcode }}<br/>
                {{ $invoice->sellerAddress->country }}
            </p>
        </td>
        <td class="clientDetails">
            <h3>Recipient</h3>
                <p>
                    <strong>
                        {{ $invoice->recipientAddress->first_name }}
                        {{ $invoice->recipientAddress->last_name }}
                    </strong><br/>
                    {{ $invoice->recipientAddress->address1 }}<br/>
                    {{ $invoice->recipientAddress->address2 }}<br/>
                    {{ $invoice->recipientAddress->city }}<br/>
                    {{ $invoice->recipientAddress->postcode }}<br/>
                    {{ $invoice->recipientAddress->country }}
                </p>
        </td>
    </tr>
</table>
<div class="card">
    <table class="table mb-0" id="order_items">
        @foreach($invoice->items as $item)
        <tr>
            <td>
                <strong>{{ $item->name }}</strong><br/>
            </td>
            <td>
                @if ($item->discounted_price > 0)
                    <del>&pound;{{ number_format($item->price, 2) }}</del>
                    &pound;{{ number_format($item->discounted_price, 2) }} x {{ $item->quantity }}
                @else
                    &pound;{{ number_format($item->price, 2) }} x {{ $item->quantity }}
                @endif
            </td>
            <td class="text-right">
                &pound;{{ number_format($item->line_total, 2) }}
            </td>
        </tr>
        @endforeach
        <tr>
            <td></td>
            <td><strong>Total</strong></td>
            <td class="text-right">
                <strong>
                    &pound;{{ number_format($invoice->amount, 2) }}
                </strong>
            </td>
        </tr>
    </table>
</div>

</body>
</html>
