<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class CarConfiguratorSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->getData())
            ->each(fn ($data) => Settings::make($data));
    }

    private function getData()
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Car Configurator',
                'group' => 'Content',
                'name' => 'Enquiry Form',
                'config_key' => 'configurator-enquiry-form',
                'type' => 'string',
                'source' => 'forms',
                'value' => '',
                'feature' => 'car-configurator',
                'description' => 'Select the form that will be used as enquiry format for car configurator journey',
                'order' => 11,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Car Configurator',
                'group' => 'Content',
                'name' => 'Test Drive Form',
                'config_key' => 'configurator-test-drive-form',
                'type' => 'string',
                'source' => 'forms',
                'value' => '',
                'feature' => 'car-configurator',
                'description' => 'Select the form that will be used as test drive enquiry for car configurator journey',
                'order' => 12,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Car Configurator',
                'group' => 'Content',
                'name' => 'Content block',
                'config_key' => 'configurator-content-element',
                'type' => 'string',
                'source' => 'elements',
                'value' => '',
                'feature' => 'car-configurator',
                'description' => 'Content element defining structure on car configurator overview section',
                'order' => 13,
            ],
        ];
    }
}
