<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class OfferUrlWwwSettingSeeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'Offers',
                'name' => 'Include www in offer page URL path',
                'config_key' => 'offers-url-path-include-www',
                'type' => 'boolean',
                'value' => false,
            ],
        ];
    }
}
