<?php

namespace App\Console\Commands;

use App\ExportMapRepository;
use App\Models\ExportMap;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\App;

class RunExportMaps extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'export-maps:run';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Run export maps task to send out feeds';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $exportMapRepository = App::make(ExportMapRepository::class);
        $exportMapRepository->getDueMaps()->each(fn(ExportMap $exportMap) => $exportMapRepository->run($exportMap));
    }
}
