<?php

namespace App\Listeners;

use App\Events\VehiclePriceChangedDuringStockSync;
use App\Facades\Settings;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Mtc\MercuryDataModels\Services\FinanceService;
use Mtc\MercuryDataModels\Services\FinanceServiceHelper;

class RefreshFinanceOnVehiclePriceChange implements ShouldQueue
{
    use DispatchesJobs;

    public $queue = 'sync';

    public function handle(VehiclePriceChangedDuringStockSync $event): void
    {
        if (FinanceServiceHelper::hasEnabledProvider() && !Settings::get('finance-batch-update')) {
            (new FinanceService())->request($event->getVehicle());
        }
    }
}
