@extends('crm::emails.layout', [
    'subject' => 'Repeated Process Failure Alert',
])

@section('content')

    <p>
        <strong>{{ $processType }}</strong> has failed multiple times consecutively for <strong>{{ $provider }}</strong> on tenant <strong>{{ $tenant }}</strong>.
    </p>

    <p>This requires investigation as the process is consistently failing.</p>

    <h3>Latest Error</h3>
    <p><strong>Error Message:</strong> {{ $processLog->error_message }}</p>

    <p><strong>Started:</strong> {{ $processLog->started_at?->format('Y-m-d H:i:s') }}</p>
    <p><strong>Failed:</strong> {{ $processLog->finished_at?->format('Y-m-d H:i:s') }}</p>

    @if($processLog->error_details)
        <h3>Error Details</h3>
        <pre style="background: #f5f5f5; padding: 10px; overflow-x: auto; font-size: 12px;">{{ json_encode($processLog->error_details, JSON_PRETTY_PRINT) }}</pre>
    @endif

@endsection
