<?php

namespace App\Crm;

use App\Contracts\AddsDealershipFields;
use App\Contracts\ForwardsReservationToCrm;
use App\Facades\Settings;
use App\Services\DealerWebLmsApi;
use App\Services\FuseCrmApi;
use Illuminate\Support\Facades\App;
use Mtc\Crm\Contracts\EnquiryAction;
use Mtc\Crm\Contracts\EnquiryActionModel;
use Mtc\Crm\Contracts\EnquiryModel;
use Mtc\VehicleReservations\Reservation;

class StormMSDynamics implements EnquiryAction, AddsDealershipFields
{
    use CheckForExpiredAction;

    public function __construct()
    {
        //
    }

    public function enabled(): bool
    {
        return Settings::get('storm-ms-dynamics-crm-enabled') === true;
    }

    /**
     * Data fields to add to form
     *
     * @return array
     */
    public function formAdditionalDataFields(): array
    {
        return [];
    }

    public static function customFields(): array
    {
        return [
            'occupation_title' => 'Occupation Title',
            'employer_name' => 'Employer Name',
            'trade_in_value' => 'Trade In Value or Deposit',
            'eircode' => 'Eircode',
            'branch' => 'Your Branch',
            'select_branch' => 'Select Branch',
            'monthly_mortgage' => 'Monthly Mortgage / Rent Payment',
            'employment_type' => 'Employment Type',
            'years_with_bank' => 'Years With Bank',
            'term' => 'Term',
            'employment_status' => 'Employment Status',
            'marital_status' => 'Marital Status',
            'employer_county' => 'Employer County',
            'date_of_birth' => 'Date of Birth',
            'address' => 'Address',
            'bank' => 'Bank',
            'salary_per_month' => 'Net Salary Per Month',
            'time_at_address' => 'Time at Address',
            'trade_in_registration_number' => 'Trade In Registration Number',
            'residential_status' => 'Residential Status',
            'account_number' => 'Account Number',
            'account_name' => 'Account Name',
            'pps_number' => 'PPS Number',
            'county' => 'County',
            'previous_address' => 'Previous Address',
            'previous_address_2' => 'Previous Address (2nd)',
            'previous_county' => 'Previous County',
            'previous_county_2' => 'Previous County (2nd)',
            'time_at_previous_address' => 'Time at Previous Address',
            'time_at_previous_address_2' => 'Time at Previous Address (2nd)',
            'asset_purchase_price' => 'Asset Purchase Price',
            'employment_phone_number' => 'Employment Phone Number',
            'maiden_name' => 'Maiden Name',
            'nationality' => 'Nationality',
            'borrower_type' => 'Borrower Type',
            'employer_address' => 'Employer Address',
            'account_type' => 'Account Type',
            'title' => 'Title',
            'number_of_dependents' => 'Number of Dependents',
            'middle_name' => 'Middle Name',
            'house_number' => 'House Name or Number',
            'employment_time' => 'Time In This Employment',
            'industry_category' => 'Industry Category',
            'other_income' => 'Other Income',
            'current_vehicle_mileage' => 'Current Vehicle Mileage',
            'agree_terms' => 'Terms & Conditions',
        ];
    }
    /**
     * Data fields to add to questions
     *
     * @return array[]
     */
    public function formQuestionDataFields(): array
    {
        return [
            'ms-dynamics-field' => [
                'type' => 'select',
                'label' => 'Field mapped against MS Dynamics',
                'choices' => array_merge([
                    'title' => 'Title',
                    'first_name' => 'First Name',
                    'last_name' => 'Last Name',
                    'full_name' => 'Full Name',

                    'phone' => 'Mobile Phone Number',
                    'email' => 'Email Address',
                    'message' => 'Message/Comments',

                    'building_ext' => 'Building ext',
                    'building_int' => 'Building int',
                    'country_code' => 'Country (Code)',
                    'district' => 'District',
                    'postcode' => 'Postcode',
                    'primary_locality' => 'Primary locality',
                    'secondary_locality' => 'Secondary locality',
                    'street' => 'Street',

                    'preferred_date' => 'Preferred booking date',
                    'preferred_date_approximate' => 'Preferred booking time of day (approximate)',

                    'contact_methods' => 'Preferred means of contact',
                    'source_url' => 'External URL for additional vehicle details (must start with https://)',
                ], self::customFields())
            ]
        ];
    }

    public function dealershipAdditionalDataFields(): array
    {
        return [
            'ms-dynamics-dealership' => [
                'type' => 'text',
                'label' => 'Dealership hash for link with MS Dynamics'
            ],
        ];
    }


    public function handle(EnquiryActionModel $action, EnquiryModel $enquiry): ?bool
    {
        return true;
    }

    public function successDetails(): string
    {
        return 'Available on API endpoint';
    }

    public function failureReason(): string
    {
        return '';
    }
}
