<?php

namespace App\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;
use Mtc\MercuryDataModels\Vehicle;

class VehicleUpdated
{
    use Dispatchable;
    use InteractsWithSockets;
    use SerializesModels;

    /**
     * Create a new event instance.
     *
     * @return void
     */
    public function __construct(
        private Vehicle $vehicle,
        private ?float $previousPrice = null,
        private ?int $previousImageCount = null,
        private ?int $previousVideoCount = null
    ) {
        //
    }

    public function getVehicle(): Vehicle
    {
        return $this->vehicle;
    }

    public function getPreviousPrice(): ?float
    {
        return $this->previousPrice;
    }

    public function getPreviousImageCount(): ?int
    {
        return $this->previousImageCount;
    }

    public function getPreviousVideoCount(): ?int
    {
        return $this->previousVideoCount;
    }
}
