<?php

namespace App\Mail;

use App\Facades\Settings;
use App\Traits\GetsColourSettings;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class StockSyncFailedMail extends Mailable
{
    use Queueable;
    use SerializesModels;
    use GetsColourSettings;

    /**
     * Create a new message instance.
     */
    public function __construct(private readonly \Throwable $exception, private readonly string $tenant_id)
    {
        //
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Stock sync failed for ' . $this->tenant_id,
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            view: 'emails.alerts.stock-sync',
            with: [
                'tenant' => $this->tenant_id,
                'exception' => $this->exception,
                'site_name' => Settings::get('app-name'),
                'site_logo' => Settings::get('site-logo'),
                'site_logo_alternate' => Settings::get('site-alternate-logo'),
                'colours' => $this->getColourSettings(),
            ],
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }
}
