<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class GlobalWhatsappSettingSeeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Site',
                'section' => 'General',
                'group' => 'Site Details',
                'name' => 'Contact WhatsApp number',
                'config_key' => 'app-contact-whastapp-number',
                'type' => 'string',
                'value' => '',
            ]
        ];
    }
}
