<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;
use Mtc\MercuryDataModels\Setting;

class OfferOfferTypeFilterSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Setting::query()
            ->where('config_key', 'automotive-vehicle-filters-offer_type')
            ->delete();

        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Offer Filtering',
                'name' => 'Offer Type',
                'config_key' => 'automotive-vehicle-filters-offer-offer_type',
                'type' => 'boolean',
                'value' => false,
            ],
        ];
    }
}
