<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>{{ $site_name }}</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <meta name="color-scheme" content="light">
    <meta name="supported-color-schemes" content="light">
    <style>
        @media only screen and (max-width: 600px) {
            .inner-body {
                width: 100% !important;
            }
            .footer {
                width: 100% !important;
            }
        }
        @media only screen and (max-width: 500px) {
            .button {
                width: 100% !important;
            }
        }
    </style>
</head>
<body style="font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Helvetica, Arial, sans-serif; background-color: #f4f4f4; margin: 0; padding: 0;">

<table class="wrapper" width="100%" cellpadding="0" cellspacing="0" role="presentation" style="background-color: #f4f4f4;">
    <tr>
        <td align="center" style="padding: 20px;">
            <table class="content" width="100%" cellpadding="0" cellspacing="0" role="presentation" style="max-width: 600px; margin: 0 auto;">
                <!-- Header -->
                <tr>
                    <td style="background: {{ $colours['primary'] ?? '#2e2c2f' }}; padding: 20px; text-align: center; border-radius: 8px 8px 0 0;">
                        @if(!empty($site_logo['url']))
                            <a href="{{ $site_url }}" style="display: inline-block;">
                                <img src="{{ $site_logo['url'] }}" style="height: 50px; max-width: 200px;" alt="{{ $site_name }}">
                            </a>
                        @else
                            <h1 style="color: #ffffff; margin: 0; font-size: 24px;">{{ $site_name }}</h1>
                        @endif
                    </td>
                </tr>

                <!-- Body -->
                <tr>
                    <td style="background-color: #ffffff; padding: 40px 30px;">
                        <h1 style="margin: 0 0 20px 0; color: #333333; font-size: 24px;">
                            @if($event_type->value === 'price_drop')
                                {{ __('emails.vehicle_subscription.heading.price_drop') }}
                            @elseif($event_type->value === 'images_added')
                                {{ __('emails.vehicle_subscription.heading.images_added') }}
                            @elseif($event_type->value === 'video_added')
                                {{ __('emails.vehicle_subscription.heading.video_added') }}
                            @endif
                        </h1>

                        @if(!empty($customer->first_name))
                            <p style="margin: 0 0 20px 0; color: #555555; font-size: 16px;">
                                {{ __('emails.vehicle_subscription.greeting', ['name' => $customer->first_name]) }}
                            </p>
                        @endif

                        <!-- Vehicle Card -->
                        <table width="100%" cellpadding="0" cellspacing="0" style="margin: 20px 0; border: 1px solid #e5e5e5; border-radius: 8px; overflow: hidden;">
                            <tr>
                                <td style="background-color: #f8f9fa; padding: 20px;">
                                    @if(!empty($vehicle_image))
                                        <img src="{{ $vehicle_image }}" alt="{{ $vehicle->title ?? $vehicle->name }}"
                                             style="width: 100%; height: auto; margin-bottom: 15px; border-radius: 4px;">
                                    @endif

                                    <h2 style="margin: 0 0 10px 0; color: #333333; font-size: 20px;">
                                        {{ $vehicle->title ?? $vehicle->name }}
                                    </h2>

                                    @if($event_type->value === 'price_drop' && isset($event_data['old_price']) && isset($event_data['new_price']))
                                        <p style="margin: 10px 0;">
                                            <span style="text-decoration: line-through; color: #999999; font-size: 16px;">
                                                {{ \App\Facades\Settings::get('currency-symbol', '£') }}{{ number_format($event_data['old_price']) }}
                                            </span>
                                            <span style="font-size: 22px; font-weight: bold; color: #28a745; margin-left: 10px;">
                                                {{ \App\Facades\Settings::get('currency-symbol', '£') }}{{ number_format($event_data['new_price']) }}
                                            </span>
                                        </p>
                                        <p style="color: #28a745; font-weight: bold; margin: 10px 0;">
                                            {{ __('emails.vehicle_subscription.price_drop_amount', [
                                                'amount' => \App\Facades\Settings::get('currency-symbol', '£') . number_format($event_data['old_price'] - $event_data['new_price'])
                                            ]) }}
                                        </p>
                                    @elseif($event_type->value === 'images_added' && isset($event_data['new_count']))
                                        <p style="margin: 10px 0; color: #555555;">
                                            {{ __('emails.vehicle_subscription.images_added_count', ['count' => $event_data['new_count']]) }}
                                        </p>
                                    @elseif($event_type->value === 'video_added')
                                        <p style="margin: 10px 0; color: #555555;">
                                            {{ __('emails.vehicle_subscription.video_added_message') }}
                                        </p>
                                    @endif

                                    <p style="margin: 20px 0 0 0;">
                                        <a href="{{ $vehicle_url }}"
                                           style="display: inline-block; padding: 14px 28px; background-color: {{ $colours['primary'] ?? '#007bff' }}; color: #ffffff; text-decoration: none; border-radius: 4px; font-weight: bold; font-size: 16px;">
                                            {{ __('emails.vehicle_subscription.view_vehicle') }}
                                        </a>
                                    </p>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>

                <!-- Footer -->
                <tr>
                    <td style="background-color: #f8f9fa; padding: 20px 30px; text-align: center; border-radius: 0 0 8px 8px;">
                        @if(!empty($footer))
                            <div style="margin-bottom: 15px; color: #666666; font-size: 14px;">
                                {!! $footer !!}
                            </div>
                        @endif

                        <p style="color: #999999; font-size: 12px; margin: 0;">
                            {{ __('emails.vehicle_subscription.unsubscribe_text') }}
                            <a href="{{ $unsubscribe_url }}" style="color: {{ $colours['primary'] ?? '#007bff' }};">{{ __('emails.vehicle_subscription.unsubscribe_link') }}</a>
                            {{ __('emails.vehicle_subscription.unsubscribe_or') }}
                            <a href="{{ $unsubscribe_all_url }}" style="color: {{ $colours['primary'] ?? '#007bff' }};">{{ __('emails.vehicle_subscription.unsubscribe_all_link') }}</a>
                        </p>
                    </td>
                </tr>
            </table>
        </td>
    </tr>
</table>

</body>
</html>
