<?php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;

class DealershipDepartmentUniqueNameRule implements Rule
{
    public function passes($attribute, $departments)
    {
        return collect($departments)
            ->pluck('name')
            ->duplicates()
            ->isEmpty();
    }

    public function message()
    {
        return 'Department names must be unique';
    }
}
