<?php

namespace Tests\Feature;

use App\Facades\Settings;
use App\Mail\FailedEnquiryReport;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;
use Tests\UserForTenant;

class SiteBrandingOverrideTest extends TestCase
{
    use RefreshDatabase;
    use UserForTenant;

    protected $tenancy = true;

    public function testBrandingSettings()
    {
        Settings::make([
            'tab' => 'Site',
            'section' => 'General',
            'group' => 'Branding',
            'name' => 'Text Colour',
            'config_key' => 'app-text-colour',
            'type' => 'string',
            'value' => '#000000',
        ]);

        Settings::make([
            'tab' => 'Site',
            'section' => 'General',
            'group' => 'Branding',
            'name' => 'Text Colour Override',
            'config_key' => 'app-text-colour-override',
            'type' => 'string',
            'value' => '',
        ]);

        Settings::make([
            'tab' => 'Site',
            'section' => 'General',
            'group' => 'Branding',
            'name' => 'Primary Colour',
            'config_key' => 'app-primary-colour',
            'type' => 'string',
            'value' => '#aaaaaa',
        ]);

        Settings::make([
            'tab' => 'Site',
            'section' => 'General',
            'group' => 'Branding',
            'name' => 'Primary Colour',
            'config_key' => 'app-primary-colour-override',
            'type' => 'string',
            'value' => '',
        ]);

        $report = new FailedEnquiryReport(collect([]));
        $content = $report->build();

        $this->assertArrayHasKey('colours', $content->viewData);
        $this->assertArrayHasKey('app-text-colour', $content->viewData['colours']);
        $this->assertArrayHasKey('app-primary-colour', $content->viewData['colours']);

        // assert that nothing was overridden
        $this->assertEquals('#000000', $content->viewData['colours']['app-text-colour']);
        $this->assertEquals('#aaaaaa', $content->viewData['colours']['app-primary-colour']);
    }

    public function testBrandingSettingsOverride()
    {
        Settings::make([
            'tab' => 'Site',
            'section' => 'General',
            'group' => 'Branding',
            'name' => 'Text Colour',
            'config_key' => 'app-text-colour',
            'type' => 'string',
            'value' => '#000000',
        ]);

        Settings::make([
            'tab' => 'Site',
            'section' => 'General',
            'group' => 'Branding',
            'name' => 'Text Colour Override',
            'config_key' => 'app-text-colour-override',
            'type' => 'string',
            'value' => '#ffffff',
        ]);

        Settings::make([
            'tab' => 'Site',
            'section' => 'General',
            'group' => 'Branding',
            'name' => 'Primary Colour',
            'config_key' => 'app-primary-colour',
            'type' => 'string',
            'value' => '#aaaaaa',
        ]);

        Settings::make([
            'tab' => 'Site',
            'section' => 'General',
            'group' => 'Branding',
            'name' => 'Primary Colour',
            'config_key' => 'app-primary-colour-override',
            'type' => 'string',
            'value' => '',
        ]);

        $report = new FailedEnquiryReport(collect([]));
        $content = $report->build();

        $this->assertArrayHasKey('colours', $content->viewData);
        $this->assertArrayHasKey('app-text-colour', $content->viewData['colours']);

        // assert that we did override the intended setting
        $this->assertEquals('#ffffff', $content->viewData['colours']['app-text-colour']);

        // assert that we didn't override something we didn't mean to
        $this->assertEquals('#aaaaaa', $content->viewData['colours']['app-primary-colour']);
    }
}
